#include </lib/std.mi>

Function setSeekAnim(int posValue);
Function updateSeek(int x, int y);

Global Layer Seek;
Global Map SeekMap;
Global Text SongTicker;
Global Timer SongTickerTimer, SongPlayingTimer;
Global Boolean SeekChanging;

System.onScriptLoaded() {
	Group ScriptGrp = getScriptGroup();

	//get Seek Layer and SongTicker
	Seek = ScriptGrp.findObject("SeekAnim");
	SongTicker = ScriptGrp.findObject("SongTicker");

	// Initialize our timers
	SongTickerTimer = new Timer;
	SongTickerTimer.setDelay(750);
	SongPlayingTimer = new Timer;
	SongPlayingTimer.setDelay(1000);

	//initialize Map
	SeekMap = new Map;
	SeekMap.loadMap("player.map.seek");

	//Start SongPlayingTimer if Media is Playing
	if (System.getStatus() != 0) {
		SongPlayingTimer.start();
		setSeekAnim(255 * System.getPosition() / System.getPlayItemLength());
	} else {
		setSeekAnim(0);
	}
}

// When Media Plays, start updates.
System.onPlay() {
	SongPlayingTimer.start();
}

// When Media is Stopped, discontinue updates.
System.onStop() {
	SongPlayingTimer.stop();
	setSeekAnim(0);
}

// Updates Seek as Media Advances
SongPlayingTimer.onTimer() {
	setSeekAnim(255 * System.getPosition() / System.getPlayItemLength());
}

// Clears text area
SongTickerTimer.onTimer() {
	SongTicker.setText("");
	SongTickertimer.stop();
}

//sets the Animation to correct frame
setSeekAnim(int Value) {
	Region r = new Region;
	r.loadFromMap(SeekMap, Value, 1);
	Seek.setRegion(r);
	delete r;
}

// Handles Seek Mouse Events
Seek.onLeftButtonDown(int x, int y) {
	SongPlayingTimer.stop();
	SeekChanging = 1;
	updateSeek(x, y);
}
Seek.onLeftButtonUp(int x, int y) {
	SongPlayingTimer.start();
	if (SeekChanging) {
		SeekChanging = 0;
		updateSeek(x, y);
	}
}
Seek.onMouseMove(int x, int y) {
	if (SeekChanging) {
		updateSeek(x, y);
	}
}

// Updates Seek Image and System Position
updateSeek(int x, int y) {
	int newValue = SeekMap.getValue(x - Seek.getLeft(), y - Seek.getTop());
	if (System.getPlayItemLength() >= 0) {
		int p = (newValue * 100) / 255;
		int s = (newValue * System.getPlayItemLength()) / 255;
		Songtickertimer.stop();
		Songtickertimer.start();
		Songticker.setAlternateText(System.integerToTime(s) + "/" + System.integerToTime(System.getPlayItemLength()) + " (" + System.integerToString(p) + "%)");
		if (!SeekChanging) {
			System.seekTo(s);
		}
		setSeekAnim(255 * s / System.getPlayItemLength());
	}
}

System.onScriptUnloading() {
	delete SongPlayingTimer;
	delete SongTickerTimer;
	delete SeekMap;
}
