/*************************************************************

  KameleonDUI - eqsliders.m
  by Leechbite

  - this script controls the eq sliders.

*************************************************************/

#include <lib/std.mi>

#define PREAMP 10

function changeslider(int band);

Global group frameGroup;
class Animatedlayer eqSlider;
Global eqSlider eqslider1,eqslider2,eqslider3,eqslider4,eqslider5,
		eqslider6,eqslider7,eqslider8,eqslider9,eqslider10,
		eqsliderPA;

Global boolean eqchange;

System.onScriptLoaded() {

  frameGroup = getScriptGroup();

  eqslider1 = frameGroup.findObject("eq.slider.1");
  eqslider2 = frameGroup.findObject("eq.slider.2");
  eqslider3 = frameGroup.findObject("eq.slider.3");
  eqslider4 = frameGroup.findObject("eq.slider.4");
  eqslider5 = frameGroup.findObject("eq.slider.5");
  eqslider6 = frameGroup.findObject("eq.slider.6");
  eqslider7 = frameGroup.findObject("eq.slider.7");
  eqslider8 = frameGroup.findObject("eq.slider.8");
  eqslider9 = frameGroup.findObject("eq.slider.9");
  eqslider10 = frameGroup.findObject("eq.slider.10");
  eqsliderPA = frameGroup.findObject("eq.slider.pre");

  int x;
  for (x=0; x<=10; x++)
    changeslider(x);
    
  system.onEqChanged(getEQ());
}

System.onScriptUnLoading() {
	return;
}

system.onEQBandChanged(int band, int newvalue) {
  changeslider(band);
}

system.onEQPreampChanged(int newvalue) {
  changeslider(PREAMP);
}

changeslider(int band) {
  eqslider eqband;
  string bandstr;
  int bandval;

  if (band==PREAMP) {
    bandstr = "pre";
    bandval = getEQPreamp();
  } else {
    bandstr = integertoString(band+1);
    bandval = getEQBand(band);
  }

  eqband = frameGroup.findObject("eq.slider."+bandstr);

  eqband.gotoframe(eqband.getlength()*(127+bandval)/255);
}

eqSlider.onLeftButtonDown(int x, int y) {
  eqchange = 1;
}

eqSlider.onMouseMove(int x, int y) {
  if (eqchange) {
    string bandstr = gettoken(getID(), ".", 2);

    if (bandstr=="pre") {
      setEQPreamp(127-254*(y-getTop())/getHeight());
    } else {
      setEQBand(stringtoInteger(bandstr)-1,127-254*(y-getTop())/getHeight());
    }
  }
}

eqSlider.onLeftButtonUp(int x, int y) {
  if (eqchange) {
    string bandstr = gettoken(getID(), ".", 2);

    if (bandstr=="pre") {
      setEQPreamp(127-254*(y-getTop())/getHeight());
    } else {
      setEQBand(stringtoInteger(bandstr)-1,127-254*(y-getTop())/getHeight());
    }
  }
  eqchange = 0;
}

system.onEqChanged(int eqon) {
	if (eqon) {
		eqslider1.setAlpha(255);
		eqslider2.setAlpha(255);
		eqslider3.setAlpha(255);
		eqslider4.setAlpha(255);
		eqslider5.setAlpha(255);
		eqslider6.setAlpha(255);
		eqslider7.setAlpha(255);
		eqslider8.setAlpha(255);
		eqslider9.setAlpha(255);
		eqslider10.setAlpha(255);
		eqsliderPA.setAlpha(255);
	} else {
		eqslider1.setAlpha(128);
		eqslider2.setAlpha(128);
		eqslider3.setAlpha(128);
		eqslider4.setAlpha(128);
		eqslider5.setAlpha(128);
		eqslider6.setAlpha(128);
		eqslider7.setAlpha(128);
		eqslider8.setAlpha(128);
		eqslider9.setAlpha(128);
		eqslider10.setAlpha(128);
		eqsliderPA.setAlpha(128);
	}
}

eqSlider.onEnterArea() {
  return;
}

eqSlider.onLeaveArea() {
  return;
}