/*************************************************************

  sendparams.m
  by Leechbite

  general purpose script to change params on objects that
  cannot be changed with <sendparams>, i.e. outside the group/layout
  definition.
  
  param = "contID,layoutID,targetID,param1,param2,..."
  
  contID - id of main container;
  layoutID - id of main layout;
  targetID - id of target object;
  param1,param2... - parameters to be changed

*************************************************************/

#include <lib/std.mi>

Global container shadowCont;
Global layout mainLayout;
Global guiObject target;

Global string contID, layID, targetID;

System.onScriptLoaded() {

	string param = getParam();

	
	contID = getToken(param,",",0);
	layID =  getToken(param,",",1);
	targetID = getToken(param,",",2);


	container mainCont = getContainer(contID);
	if (maincont) mainLayout = mainCont.getLayout(layID);
	
	if (mainLayout) {
		target = mainLayout.findObject(targetID);
		if (!target) return;
		
		int c = 3;
		string expr = getToken(param,",",c);
		string prop, value;
		
		while (expr!="") {
			prop = getToken(expr,"=",0);
			value = getToken(expr,"=",1);
			
			target.setXMLParam(prop,value);
			
			c++;
			expr = getToken(param,",",c);
		}
	}
						
}