// never forget to include std.mi
#include "../../../lib/std.mi"

//declares global variables for use in script
Global Group DrawerGrpshade;
Global Layer Drawershade, DrawerInfoshade;
Global Int DrawerStatus;  //0 = closed, 1 = open
Global Int StartX, StartY, EndX, EndY;
Global Button toggle;


//when the script is loaded, do this


System.onScriptLoaded() {
  	Group mainFull=getContainer("main").getLayout("shade");
    	toggle=mainFull.getobject("eqshade");




	//gets the group that has the objects we want
	DrawerGrpshade = getScriptGroup();;

	//now that we have the group, get the layers in the group
	Drawershade = DrawerGrpshade.findObject("Drawershade");
	DrawerInfoshade = DrawerGrpshade.findObject("DrawerInfoshade");

	StartX = StringToInteger(DrawerGrpshade.getXMLparam("x"));
	StartY = StringToInteger(DrawerGrpshade.getXMLparam("y"));
	EndX = StringToInteger(DrawerInfoshade.getXMLparam("x"));
	EndY = StringToInteger(DrawerInfoshade.getXMLparam("y"));

	//initialize our drawer flag to closed
	DrawerStatus = 0;

}//end onScriptLoaded()

//when the left mouse button is released within Drawer, do this
toggle.onLeftButtonUp(int x, int y) {
  if (DrawerStatus == 0) {  // if our Drawer is closed, make it slide open
    if (!DrawerGrpshade.isGoingToTarget()) {  //makes sure it isn't already moving
      DrawerGrpshade.setTargetX(EndX);  //set the x coordinate you want the drawer to slide to
      DrawerGrpshade.setTargetY(EndY);  //set the y coordinate you want the drawer to slide to
      DrawerGrpshade.setTargetSpeed(1);  //sets the speed the drawer will slide at(higher is slower)
      DrawerGrpshade.gotoTarget();  //now that we have our target values and speed, start moving!
      DrawerStatus = 1;  //Change the flag to Open
    }
  }
  else {  // if our Drawer is open, make it slide closed
    if (!DrawerGrpshade.isGoingToTarget()) {  //makes sure it isn't already moving
      DrawerGrpshade.setTargetX(StartX);  //set the x coordinate you want the drawer to slide back to
      DrawerGrpshade.setTargetY(StartY);   //set the y coordinate you want the drawer to slide back to
      DrawerGrpshade.setTargetSpeed(1);  //sets the speed the drawer will slide at(higher is slower)
      DrawerGrpshade.gotoTarget();  //now that we have our target values and speed, start moving!
      DrawerStatus = 0;  //Change the flag to Closed
    }
  }
}