/*--------------------------------------------------------------------
 Main/Normal player group script.
--------------------------------------------------------------------*/

#include </lib/std.mi>
#include </lib/pldir.mi>

Function setTempText(String txt);
Function emptyTempText();

Global Text Songticker;

Class GuiObject HintObject;
Class ToggleButton HintToggleButton;

Global HintObject Play, Stop, Previous, Next, Pause, Thinger, Open, Eq, Ml, Pl;
Global HintToggleButton ToggleXFade, ToggleShuffle, ToggleRepeat;

System.onScriptLoaded() {

  Group pgroup = getScriptGroup();

  // Get songticker, Volbar & Seeker
  Songticker = pgroup.findObject("Songticker");
  if (songticker == null) messagebox("ooch!!", "ooch", 0, "");

  // Get Various buttons
  Play = pgroup.findObject("Play");
  Pause = pgroup.findObject("Pause");
  Stop = pgroup.findObject("Stop");
  Next = pgroup.findObject("Next");
  Previous = pgroup.findObject("Previous");
  Thinger = pgroup.findObject("Thinger");
  Open = pgroup.findObject("Eject");

  Eq = pgroup.findObject("Eq");
  Ml = pgroup.findObject("Ml");
  Pl = pgroup.findObject("Pl");

}

Songticker.onLeftButtonDblClk(int x, int y) {
  PlDir.showCurrentlyPlayingEntry();
}

HintObject.onLeftButtonDown(int x, int y) {
  if (HintObject == Play) setTempText("Play");
  else if (HintObject == Stop) setTempText("Stop");
  else if (HintObject == Pause) setTempText("Pause");
  else if (HintObject == Next) setTempText("Next");
  else if (HintObject == Previous) setTempText("Previous");
  else if (HintObject == Thinger) setTempText("Thinger");
  else if (HintObject == Open) setTempText("Open");
  else if (HintObject == Eq) setTempText("Equalizer");
  else if (HintObject == ML) setTempText("Media Library");
  else if (HintObject == Pl) setTempText("Playlist Editor");
}

HintObject.onLeftButtonUp(int x, int y) {
  emptyTempText();
}

Thinger.onRightButtonUp(int x, int y) {
  windowMenu();
  complete;
}

setTempText(String txt) {
  Songticker.setAlternateText(txt);
}

emptyTempText() {
  Songticker.setAlternateText("");
}