// never forget to include std.mi
#include "../../../lib/std.mi"

//declares global variables for use in script
Global Group DrawerGrp;
Global Layer Drawer, DrawerInfo;
Global Int DrawerStatus;  //0 = closed, 1 = open
Global Int StartX, StartY, EndX, EndY;
Global Button toggle;


//when the script is loaded, do this


System.onScriptLoaded() {
  	Group mainFull=getContainer("main").getLayout("normal");
    	toggle=mainFull.getobject("eq");




	//gets the group that has the objects we want
	DrawerGrp = getScriptGroup();;

	//now that we have the group, get the layers in the group
	Drawer = DrawerGrp.findObject("Drawer");
	DrawerInfo = DrawerGrp.findObject("DrawerInfo");

	StartX = StringToInteger(DrawerGrp.getXMLparam("x"));
	StartY = StringToInteger(DrawerGrp.getXMLparam("y"));
	EndX = StringToInteger(DrawerInfo.getXMLparam("x"));
	EndY = StringToInteger(DrawerInfo.getXMLparam("y"));

	//initialize our drawer flag to closed
	DrawerStatus = 0;

}//end onScriptLoaded()

//when the left mouse button is released within Drawer, do this
toggle.onLeftButtonUp(int x, int y) {
  if (DrawerStatus == 0) {  // if our Drawer is closed, make it slide open
    if (!DrawerGrp.isGoingToTarget()) {  //makes sure it isn't already moving
      DrawerGrp.setTargetX(EndX);  //set the x coordinate you want the drawer to slide to
      DrawerGrp.setTargetY(EndY);  //set the y coordinate you want the drawer to slide to
      DrawerGrp.setTargetSpeed(1);  //sets the speed the drawer will slide at(higher is slower)
      DrawerGrp.gotoTarget();  //now that we have our target values and speed, start moving!
      DrawerStatus = 1;  //Change the flag to Open
    }
  }
  else {  // if our Drawer is open, make it slide closed
    if (!DrawerGrp.isGoingToTarget()) {  //makes sure it isn't already moving
      DrawerGrp.setTargetX(StartX);  //set the x coordinate you want the drawer to slide back to
      DrawerGrp.setTargetY(StartY);   //set the y coordinate you want the drawer to slide back to
      DrawerGrp.setTargetSpeed(1);  //sets the speed the drawer will slide at(higher is slower)
      DrawerGrp.gotoTarget();  //now that we have our target values and speed, start moving!
      DrawerStatus = 0;  //Change the flag to Closed
    }
  }
}