DT_TOP = 0x00000000;
DT_LEFT = 0x00000000;
DT_CENTER = 0x00000001;
DT_RIGHT = 0x00000002;
DT_VCENTER = 0x00000004;
DT_BOTTOM = 0x00000008;
DT_WORDBREAK = 0x00000010;
DT_CALCRECT = 0x00000400;
DT_NOPREFIX = 0x00000800;
DT_END_ELLIPSIS = 0x00008000;

MF_SEPARATOR = 0x00000800;
MF_ENABLED = 0x00000000;
MF_GRAYED = 0x00000001;
MF_DISABLED = 0x00000002;
MF_UNCHECKED = 0x00000000;
MF_CHECKED = 0x00000008;
MF_STRING = 0x00000000;
MF_POPUP = 0x00000010;

ColorTypeCUI = {
	text: 0,
	selection_text: 1,
	inactive_selection_text: 2,
	background: 3,
	selection_background: 4,
	inactive_selection_background: 5,
	active_item_frame: 6
};

FontTypeCUI = {
	items: 0,
	labels: 1
};

ColorTypeDUI = {
	text: 0,
	background: 1,
	highlight: 2,
	selection: 3
};

FontTypeDUI = {
	defaults: 0,
	tabs: 1,
	lists: 2,
	playlists: 3,
	statusbar: 4,
	console: 5
};

function RGB(r,g,b) {
	return (0xff000000|(r<<16)|(g<<8)|(b)); 
}

function get_font() {
	if (g_instancetype == 0) {
		g_font = window.GetFontCUI(FontTypeCUI.items);
	} else if (g_instancetype == 1) {
		g_font = window.GetFontDUI(FontTypeDUI.defaults);
	}
}

function get_colors() {
	if (g_instancetype == 0) {
		g_textcolor = window.GetColorCUI(ColorTypeCUI.text);
		g_textcolor_hl = window.GetColorCUI(ColorTypeCUI.text);
		g_backcolor = window.GetColorCUI(ColorTypeCUI.background);
	} else if (g_instancetype == 1) {
		g_textcolor = window.GetColorDUI(ColorTypeDUI.text);
		g_textcolor_hl = window.GetColorDUI(ColorTypeDUI.highlight);
		g_backcolor = window.GetColorDUI(ColorTypeDUI.background);
	}
}

function on_playlist_switch() {
	on_item_focus_change();
}

function on_colors_changed() {
	get_colors();
	window.Repaint();
}

function on_font_changed() {
	get_font();
	window.Repaint();
}

function on_item_focus_change() {
	if (g_metadb) window.UnwatchMetadb();
	g_metadb = fb.IsPlaying ? fb.GetNowPlaying() : fb.GetFocusItem();
	if (g_metadb) {
		try { on_metadb_changed(); } catch(e) {}
		window.WatchMetadb(g_metadb);
	}
}

g_metadb = fb.GetFocusItem();
g_instancetype = window.InstanceType;
get_font();
get_colors();